/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.nio.file.Path;

// Must be publc to allow access from AppImageLayout.toPathGroup()
public interface MacApplicationLayoutMixin {

    /**
     * Path to the root Java runtime directory in the application image.
     * The root Java runtime directory should have "Contents/Home" subdirectory.
     */
    Path runtimeRootDirectory();

    record Stub(Path runtimeRootDirectory) implements MacApplicationLayoutMixin {}
}
