/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.util.Optional;

public interface MacPackageMixin {

    /**
     * Gets sign status of the predefined app image.
     * <p>
     * Returns {@code Optional.of(Boolean.TRUE)} if the predefined app image is
     * available and is signed.
     * <p>
     * Returns {@code Optional.of(Boolean.FALSE)} if the predefined app image is
     * available and is unsigned.
     * <p>
     * Returns any empty {@link Optional} instance if the predefined app image is
     * unavailable.
     *
     * @return sign status of the predefined app image if any
     */
    Optional<Boolean> predefinedAppImageSigned();

    record Stub(Optional<Boolean> predefinedAppImageSigned) implements MacPackageMixin {
    }
}
