#!/bin/sh
WBFOLDER="`dirname $0`"
cd ${WBFOLDER}
cd ..
pwd
JAR="`ls lib/falcom-project-workbench-[[:digit:]]*.jar`"
JAVADIR=./jre/bin/
JAVA=./jre/bin/java


if [ -z "$WB_SERVER" ]; then
  #WB_SERVER="device-falcom-dev2-pip.germanycentral.cloudapp.microsoftazure.de"
  #WB_SERVER="62.159.102.134"
  #WB_SERVER="127.0.0.1"
  WB_SERVER="stage.d2sphere.com"
fi
if [ -z "$WB_PORT" ]; then
  WB_PORT="4444"
fi

if [ -z "$WB_ENCRYPTION" ]; then
  #WB_ENCRYPTION="TLS"
  #WB_ENCRYPTION="AES"
  WB_ENCRYPTION="PLAIN"
fi

if [ -z "$WB_DEVICES" ]; then
  WB_DEVICES="10"
fi

if [ -z "$WB_START" ]; then
  WB_START="0"
fi

if [ -z "$WB_DELAY" ]; then
  WB_DELAY="5"
fi

JAVA_LIB_PATH=./lib:./lib/linux_x86_64/
export JAVA_LIB_PATH
PATH=$JAVA_LIB_PATH:$JAVADIR:$PATH
export PATH
echo "start with Parameter server ${WB_SERVER} -port ${WB_PORT} -devices ${WB_DEVICES} -start ${WB_START} -delay ${WB_DELAY} "
${JAVA} -Djava.library.path=$JAVA_LIB_PATH -cp ${JAR} de.falcom.plugins.device.devices.FSimCreator -server ${WB_SERVER} -port ${WB_PORT} -mode ${WB_ENCRYPTION} -devices ${WB_DEVICES} -start ${WB_START} -delay ${WB_DELAY}
