#!/xbin/sh

myself=${0##*/}

do_end()
{
	setdone=`getprop mount_sd.done`
	if [ -z "$setdone" ];then
		echo "$myself : Updating property: mount_sd.done = 1" > /dev/kmsg
		setprop mount_sd.done 1
	else
		echo "$myself : Property mount_sd.done already updated" > /dev/kmsg
	fi
	exit $1
}

mountdo()
{
	ret=1;
	action=0;
	mmode=`awk '/external_sdcard/{gsub(/,/," ");print $4}' /proc/mounts`
	if [ ! -z "$mmode" ] ;then
		echo "$myself : SDCARD already mounted" > /dev/kmsg
		return 0
	fi
	while [ $ret -ne 0 -a $action -lt 5 ];do
		if [ $action -ne 0 ] ;then
			echo "$myself : Retry mount $action" > /dev/kmsg
		fi
		action=$((action + 1))
		mount -o rw,errors=continue $mdev /mnt/external_sdcard 1>/dev/kmsg 2>&1
		ret=$?
	done
	return $ret
}

checkmount()
{
	ret=1;
	action=0;
	while [ $ret -ne 0 -a $action -lt 4 ];do
		mmode=`awk '/external_sdcard/{gsub(/,/," ");print $4}' /proc/mounts`
		if [ "X$mmode" == "Xrw" ];then
			echo "$myself : SDCARD mounted with $mmode mode" > /dev/kmsg
			ret=0;
			break;
		fi
		echo "$myself : SDCARD mounted with $mmode mode - remount attempt $action" > /dev/kmsg
		action=$((action + 1))
		mount -o remount,rw /mnt/external_sdcard 1>/dev/kmsg 2>&1
		ret=$?
	done
	return $ret
}

#*** u-blox modification 
# card not needed on first boot
setmmc=`getprop mount_sd.debug`
if [ -z "$setmmc" ];then
	echo "$myself : Mounting sd..." > /dev/kmsg
else
	echo "$myself : SD card not mounted for debug" > /dev/kmsg
	setprop mount_sd.done 1
	exit $1
fi
#*** u-blox modification ***

# first check mmcblock1 (used in B1 and above),
# if does not exists, check mmcblock0 (used in B0 and below)
if [ -e "/dev/block/mmcblk1p1" ]; then
    mdev=/dev/block/mmcblk1p1
elif [ -e "/dev/block/mmcblk1" ]; then
    mdev=/dev/block/mmcblk1
elif [ -e "/dev/block/mmcblk0p1" ]; then
    mdev=/dev/block/mmcblk0p1
elif [ -e "/dev/block/mmcblk0" ]; then
    mdev=/dev/block/mmcblk0
else
#*** u-blox modification ***
#	echo "$myself : SDCARD not found" | tee /dev/kmsg
	echo "$myself : SDCARD not found" > /dev/kmsg
#*** u-blox modification ***	
	do_end 0
fi

mountdo
if [ $? -ne 0 ] ;then
	echo "$myself : mount aborted" | tee /dev/kmsg
	dmesg | grep $myself
	do_end 1
fi

checkmount
if [ $? -ne 0 ] ;then
	echo "$myself : mount aborted" | tee /dev/kmsg
	dmesg | grep $myself
	do_end 1
fi
# Uppon succesful mount - check that lost+found directory present
# if - not present - create it.
sdcard=`awk '/external_sdcard/{print $2}' /proc/mounts`
if [ ! -d $sdcard/lost+found ] ;then
	echo "$myself : SDCARD - create missing /lost+found directory" > /dev/kmsg
	mkdir $sdcard/lost+found
fi

do_end 0

