#!/system/xbin/sh
myself=${0##*/}
# Uploads full and tiny logs tgz files to server

HAWK_SENDER_SERVER_URL=$(getprop ro.mrvl.hawk.logs.server.url ftp://212.199.69.13)
HAWK_SENDER_SERVER_USERNAME=$(getprop ro.mrvl.hawk.logs.server.user HAWKClient)
HAWK_SENDER_SERVER_PASSWORD=$(getprop ro.mrvl.hawk.logs.server.pass I3YGD2E5)

#2G upload speed around 236 kbps
let "DEFAULT_FTP_UPLOAD_SPEED=30*1024"

BOARD_IMEI=$(getprop persist.mrvl.version.imei 000000000000000)

if [ -z "$1" ] ; then
	echo "$myself:Wrong parameter..." > /dev/kmsg
	exit 1
fi

EVENT_DIR=$1
cd $EVENT_DIR

# if tar doesn't exist, we pack new one
FILE=`find -name \*.tar`
if [ -z "$FILE" ] ; then
	#taking only EVENT_ID(directory name)
	EVENT_ID=${EVENT_DIR##*/}

	TINY_LOG=tiny_logs.tgz
	FULL_LOG=full_logs.tgz

	if [ \( -e OFFLINE \) -a \( -e "$TINY_LOG" -o -e "$FULL_LOG" \) ] ; then
		UNIQUE_ID=$BOARD_IMEI-$RANDOM-$RANDOM-$RANDOM-$RANDOM-$RANDOM
		mkdir $EVENT_ID
		FILE=__$UNIQUE_ID.tar
		if [ -e "$TINY_LOG" ] ; then
			mv $TINY_LOG $EVENT_ID/
		fi
		if [ -e "$FULL_LOG" ] ; then
			mv $FULL_LOG $EVENT_ID/
		fi

		tar -cf $FILE $EVENT_ID
		# delete event folder to optimise space usage
		rm -r $EVENT_ID
	else
		echo "$myself: No logs found for upload.." > /dev/kmsg
		exit 1
	fi
fi

# sending logs to server
FILE_SIZE=`stat -c %s $FILE`
let "MAX_UPLOAD_TIME=$FILE_SIZE / $DEFAULT_FTP_UPLOAD_SPEED"
if [ "$MAX_UPLOAD_TIME" -lt "10" ] ; then
	#set defualt upload time to 10 seconds
	MAX_UPLOAD_TIME=10
fi
curl --connect-timeout 20 -m $MAX_UPLOAD_TIME -C - -T $FILE -u $HAWK_SENDER_SERVER_USERNAME:$HAWK_SENDER_SERVER_PASSWORD $HAWK_SENDER_SERVER_URL/
exval=$?
if [ $exval == 0 ] ; then
	NEW_FILE=`echo $FILE | cut -d '_' -f3`
	curl --connect-timeout 20 -Q "-RNFR $FILE" -Q "-RNTO $NEW_FILE" -u $HAWK_SENDER_SERVER_USERNAME:$HAWK_SENDER_SERVER_PASSWORD $HAWK_SENDER_SERVER_URL/
	if [ $? == 0 ] ; then
		#if we succeeded to upload logs, then delete from SD
		cd ..
		echo "hawk: curl upload passed" > /dev/kmsg
		rm -r $EVENT_DIR
	else
		echo "hawk: curl rename failed: $exval" > /dev/kmsg
		exit -1
	fi
else
	echo "hawk: curl upload failed: $exval" > /dev/kmsg
	exit -1
fi
