#!/xbin/sh

color()
{
case $1 in
black_green)
    echo -e '\033[40;32m'
    ;;
black_yellow)
    echo '\033[40;33m'
    ;;
black_white)
    echo -e '\033[40;37m'
    ;;
black_cyan)
    echo '\033[40;36m'
    ;;
black_blue)
    echo '\033[40;34m'
    ;;
red_yellow)
    echo '\033[41;33m'
    ;;
esac
}

#calculate interrupts per second
#/proc/interrupts
Interrupts_per_second()
{
old=$tmp
if [ "$interrupt_nr" ] ; then
    tmp=` awk -v nr="$interrupt_nr" ' BEGIN { sum =0} {if($1 == nr":") sum += $2} END{print sum}' /proc/interrupts`
else
    tmp=` awk ' BEGIN { sum =0} {sum += $2} END{print sum}' /proc/interrupts`
fi
ips=`expr \( $tmp - $old \) / $delay`
}

#get MemFree value from /proc/meminfo
MemFree()
{
mem=`awk '$1 == "MemFree:" {sum += $2}END{printf "%u",sum}' /proc/meminfo`
echo 3 > /proc/sys/vm/drop_caches
sync
}

#get TotalMIPS from /sys/devices/system/cpu/cpu0/duty_cycle
AppsMips()
{
appsmips=`tail -1 /sys/devices/system/cpu/cpu0/duty_cycle | cut -f3 -d' '`
}

#calculate MC_Utilization statictic from /sys/devices/system/cpu/cpu0/ddr_ticks
#MC_Utilization=(total_ticks-idle_ticks)/total_ticks
MC_Utilization()
{
mcutilization=`awk -F'|' 'NR>5 {total_ticks += $4;idle_ticks += $5}END{res=(total_ticks-idle_ticks)/total_ticks*100;printf "%.2f",res}' /sys/devices/system/cpu/cpu0/ddr_ticks`
}

#get latency from /sys/devices/system/cpu/cpu0/timer_irq_latency
MaxIRQLatency()
{
maxirqlatency=`awk '{print $6}' /sys/devices/system/cpu/cpu0/timer_irq_latency`
}

#all parameters necessary for save should be here
save_state()
{
tresh=`cat /sys/devices/system/cpu/cpu0/timer_irq_latency | awk '{print $2}' | cut -f1 -d','`
}

#load parameters from save_state()
load_state()
{
echo "$tresh" > /sys/devices/system/cpu/cpu0/timer_irq_latency
}

#Gathering statictics
gather_all()
{
AppsMips
MC_Utilization
MaxIRQLatency
Interrupts_per_second
MemFree
}

usage()
{
echo "Usage:";
echo "-d delay";
echo "-h help";
echo "-s [1..6]";
echo "	1 MIPS";
echo "	2 MC Utilization";
echo "	3 MaxIRQLatency";
echo "	4 Interrupts per second";
echo "	5 MemFree";
echo "	6 All";
echo "-i specify interrupt number from /proc/interrupts"
}

#cmdline processing
delay=1
option=6
O=`getopt -- d:s:i:he "$@"` || exit 1
eval set -- "$O"
while true; do
	case "$1" in
	-d) delay=$2; shift 2;;
	-s) option=$2; shift 2;;
	-i) interrupt_nr=$2; shift 2;;
	-h) usage;exit 1;;
	-e) enhance=1; shift;;
        --) shift; break;;
        *)      echo "cmdline error"; exit 1;;
        esac
done

save_state

#Set initial parameters

#set max threshold
echo "32768" > /sys/devices/system/cpu/cpu0/timer_irq_latency

# Disable/Enable DDR Statistic
echo 0 > /sys/devices/system/cpu/cpu0/ddr_stats
echo 1 > /sys/devices/system/cpu/cpu0/ddr_stats

# Enable CPU Statistic
echo 1 > /sys/devices/system/cpu/cpu0/stats

g=`color black_green`;
w=`color black_white`;
while :
do



busybox clear
case $option in
1) AppsMips;echo -e "MIPS: $g${appsmips}$w\n"
;;
2) MC_Utilization;echo -e "MC Utilization: $g${mcutilization}%$w\n"
;;
3) MaxIRQLatency;echo -e "MaxIRQLatency: $g${maxirqlatency}ms$w\n"
;;
4) Interrupts_per_second;echo -e "IPS: $g${ips}$w\n"
;;
5) MemFree;echo -e "MemFree: $g${mem}$w Kb"
;;
6) gather_all;echo -e "MIPS: $g${appsmips}$w\nMC Utilization: $g${mcutilization}%$w\nMaxIRQLatency: $g${maxirqlatency}ms$w\nIPS: $g${ips}$w\nMemFree: $g${mem}$w Kb"
;;
*) echo "Invalid option"; exit 1;
;;
esac

#Clear statistics
maxirqlatency=0
mem=0
appsmips=0
mcutilization=0
ips=0

#Wait $delay seconds or exit
read -n 1 -p "Enter q to exit:" -t $delay STR
if [ "$STR" = "q" ]; then
    load_state
    exit 1
fi
done

