#!/bin/sh

export PATH=$PATH:/usr/bin/:/usr/sbin/
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/marvell/lib/

FEATURE_MODE=$1

mount -a
mkdir -m 0777 /var/log /var/run
mkdir -m 0777 /var/lib /var/atu_data /tmp/local
mkdir -m 0775 /var/spool /var/spool/cron /var/spool/cron/crontabs
mkdir /dev/pts
mount -t devpts devpts /dev/pts
#Indicates that MIFI is running
setprop ro.mrvl.run_apx 1

# hotplug would call mdev first to handle the event, then other scripts.
echo /system/sbin/hotplug > /proc/sys/kernel/hotplug
mdev -s

echo 4 > /proc/cpu/alignment
ln -s /tmp /var/tmp

if [ ! -d /userfs ]
then
	# if /userfs is an invalid link, remove it.
	rm /userfs
	mkdir -p /userfs/
fi
EXT_SDCARD=/mnt/external_sdcard
LARGE_PART=/dbg
# cleanup last upgrade chunks and prepare for upgrade.
if [ $? -eq 0 ]; then
	rm -rf /userfs/lighttpd
	rm -rf /userfs/swup
	/etc/mount_extras.sh
	## link lighttpd & swup to sdcard
	if [ -n "`mount | grep $EXT_SDCARD`" -a ! -L /userfs/lighttpd ]; then
		ln -s $EXT_SDCARD/lighttpd /userfs/lighttpd
		mkdir $EXT_SDCARD/lighttpd
	fi
	if [ -n "`mount | grep $EXT_SDCARD`" -a ! -L /userfs/swup ]; then
		ln -s $EXT_SDCARD/swup /userfs/swup
		mkdir $EXT_SDCARD/swup
	fi

	## link lighttpd & swup to /dbg
	if [ -n "`mount | grep $LARGE_PART`" -a ! -L /userfs/lighttpd ]; then
		ln -s $LARGE_PART/lighttpd /userfs/lighttpd
		mkdir $LARGE_PART/lighttpd
	fi
	if [ -n "`mount | grep $LARGE_PART`" -a ! -L /userfs/swup ]; then
		ln -s $LARGE_PART/swup /userfs/swup
		mkdir $LARGE_PART/swup
	fi

	## if no link created, mkdir lighttpd & swup in /userfs
	if [ ! -L /userfs/lighttpd ]; then
		mkdir /userfs/lighttpd
	fi
	if [ ! -L /userfs/swup ]; then
		mkdir /userfs/swup
	fi
	rm -f $LARGE_PART/lighttpd/lighttpd-upload*
	mkdir -p /userfs/wapi
	mkdir -p /userfs/var/log/syslog
	mkdir -p /userfs/psm
	ln -s /userfs/lighttpd /tmp/lighttpd
	ln -s /userfs/swup /tmp/swup
fi

#only charger mode, router function
/usr/app/agent_server &

/etc/run-charger.sh $FEATURE_MODE	#only charger mode, router function
