#!/bin/sh
 ###########################################################
 #
 # Copyright (C) u-blox Italia
 #
 # u-blox Italia
 # Via Stazione di Prosecco 15
 # 34010 Sgonico - TRIESTE, ITALY
 #
 # All rights reserved.
 #
 # This source file is the sole property of
 # u-blox Italia. Reproduction or utilization of
 # this source in whole or part is forbidden
 # without the written consent of u-blox Italia.
 #
 ###########################################################
 #
 # Project: SE_P21
 # Purpose: Change hostless/host mode
 #
 ###########################################################
 #
 #  $Archive::                                             $
 #
 # $Workfile:: run_mode.sh                                 $
 #  $Modtime::                                             $
 # $Revision::                                             $
 #   $Author:: Fabio Piccolo                               $
 #      $Log:: 01.00 First version for Marvell platform    $
  #     $Log:: 02.00 Modification for V14.7 and further releases    $
 #
 ###########################################################

USAGE="Usage: `basename $0` [-hv] [-m arg]"
VERS="02.00"
CmdLine="/proc/cmdline"

#U_M39G_MV-89 M39G_MV_2-3307
#defined also in teldev.h
NVMIptables="/NVM/iptables_nvm.sh"
NVMIptablesDefault="/NVM/iptables_nvm_default.sh"
NVMIp6tables="/NVM/ip6tables_nvm.sh"
NVMIp6tablesDefault="/NVM/ip6tables_nvm_default.sh"

RNDIS0_IPADDR=`getprop persist.sys.ublx_rndis0_ipaddr`
RNDIS0_IPMASK=`getprop persist.sys.ublx_rndis0_ipmask`
RNDIS0_DHCPSTART=`getprop persist.sys.ublx_rndis0_dhcpst`
RNDIS0_DHCPSTOP=`getprop persist.sys.ublx_rndis0_dhcpsp`

if [ -z "$RNDIS0_IPADDR" ] || [ -z "$RNDIS0_IPMASK" ] || [ -z "$RNDIS0_DHCPSTART" ] || [ -z "$RNDIS0_DHCPSTOP" ]; then
	setprop persist.sys.ublx_rndis0_ipaddr 192.168.1.1
	setprop persist.sys.ublx_rndis0_ipmask 255.255.255.0
	setprop persist.sys.ublx_rndis0_dhcpst 192.168.1.100
	setprop persist.sys.ublx_rndis0_dhcpsp 192.168.1.100
fi

#U_M39G_MV-871
#Extract parameter from NVM command line
UBLOX_BOAR=`getprop persist.sys.ublx_cmdline.BOAR`

if [ -z "$UBLOX_BOAR" ]; then
	#Extract parameter from command line
	UBLOX_BOAR=`cat $CmdLine | sed  's/^.*BOAR=\([a-z0-9]*\).*$/\1/g'`	
	UBLOX_SYCG=`cat $CmdLine | sed  's/^.*SYCG=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_IPTM=`cat $CmdLine | sed  's/^.*IPTM=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_IMSC=`cat $CmdLine | sed  's/^.*IMSC=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_MORO=`cat $CmdLine | sed  's/^.*MORO=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_GPSC=`cat $CmdLine | sed  's/^.*GPSC=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_VOIC=`cat $CmdLine | sed  's/^.*VOIC=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_CPSR=`cat $CmdLine | sed  's/^.*CPSR=\([0-9][0-9]*\).*$/\1/g'`
	UBLOX_HAWK=`cat $CmdLine | sed  's/^.*HAWK=\([0-9][0-9]*\).*$/\1/g'`

	#Set system properties
	setprop persist.sys.ublx_cmdline.BOAR $UBLOX_BOAR	
	setprop persist.sys.ublx_cmdline.SYCG $UBLOX_SYCG
	setprop persist.sys.ublx_cmdline.IPTM $UBLOX_IPTM
	setprop persist.sys.ublx_cmdline.IMSC $UBLOX_IMSC
	setprop persist.sys.ublx_cmdline.MORO $UBLOX_MORO	
	setprop persist.sys.ublx_cmdline.GPSC $UBLOX_GPSC
	setprop persist.sys.ublx_cmdline.VOIC $UBLOX_VOIC
	setprop persist.sys.ublx_cmdline.CPSR $UBLOX_CPSR
	setprop persist.sys.ublx_cmdline.HAWK $UBLOX_HAWK
	#Reduntant MIFI configuration
	setprop persist.sys.ublx_cmdline.MIFI $UBLOX_MORO
fi

#U_M39G_MV-89
if [ ! -f $NVMIptablesDefault ]; then
        echo "Create NVMIptablesDefault" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIptablesDefault
        chmod 700 $NVMIptablesDefault
fi

if [ ! -f $NVMIptables ]; then
        echo "Create NVMIptables" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIptables
        chmod 700 $NVMIptables
fi

#M39G_MV_2-3307
if [ ! -f $NVMIp6tablesDefault ]; then
        echo "Create NVMIp6tablesDefault" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIp6tablesDefault
        chmod 700 $NVMIp6tablesDefault
fi

if [ ! -f $NVMIp6tables ]; then
        echo "Create NVMIp6tables" >> /dev/kmsg
        echo "#!/bin/sh"  > $NVMIp6tables
        chmod 700 $NVMIp6tables
fi

if [ $# -eq 0 ]; then
    echo $USAGE
    exit 0
fi

while getopts hvm: OPT; do
    case "$OPT" in
        h)
            echo $USAGE
            exit 0
            ;;
        m)
            HM=$OPTARG
            if [ $HM -gt 2 -a $HM -lt 1 ]; then
                echo $USAGE >&2
                exit 1
            fi
            ;;
        v)
            echo "`basename $0` version $VERS"
            exit 0
            ;;
        \?)
            # getopts issues an error message
            echo $USAGE >&2
            exit 1
            ;;
    esac
done
if [ -z $HM  ]; then
        exit 0
fi
if [ $HM -eq 2 ]; then
        #Set Host configuration
        sed -i -e  's/SYCG=[0-9]/SYCG=3/g' -e 's/IPTM=[0-9]/IPTM=4/g' $NVMLine
        echo "`basename $0`: Changed mode to Host." >> /dev/kmsg
elif [ $HM -eq 1 ]; then
        #Set Hostless configuration
        sed -i -e  's/SYCG=[0-9]/SYCG=2/g' -e 's/IPTM=[0-9]/IPTM=5/g' $NVMLine
        echo "`basename $0`: Changed mode to Hostless." >> /dev/kmsg
else
        # Wrong parameter
        echo "`basename $0`: Error in parameter value." >> /dev/kmsg
fi


