#!/bin/sh

SIM_DETECT_GPIO=49
SIM_DETECT_GPIO_SYSFS=/sys/class/gpio/gpio${SIM_DETECT_GPIO}
MODEMMAN_FIFO=/tmp/modemMan.fifo

# config GPIO
if [ ! -d ${SIM_DETECT_GPIO_SYSFS} ]; then
	echo ${SIM_DETECT_GPIO} > /sys/class/gpio/export
fi
echo in > ${SIM_DETECT_GPIO_SYSFS}/direction
echo 0 > ${SIM_DETECT_GPIO_SYSFS}/active_low

# get sim_detect value from GPIO
get_sim_detect() {
	local value=$(cat ${SIM_DETECT_GPIO_SYSFS}/value)
	if [ "$value" == "1" ]; then
		echo y
	else
		echo n
	fi
}

# poll sim_detect
sim_inserted_bak=0
while true; do
	sim_inserted=$(get_sim_detect)
	lwconfig --db=status write sim_inserted ${sim_inserted}
	if [ "$sim_inserted" != "$sim_inserted_bak" ]; then
		if [ -p $MODEMMAN_FIFO ]; then
			echo SIM $sim_inserted > $MODEMMAN_FIFO
		fi
		sim_inserted_bak=$sim_inserted
	fi
	sleep 2
done
