#!/bin/sh
# M39G_MV_2-885, M39G_MV_2-1803
USER_FACTORY=`getprop persist.sys.ublx_ufactory.user`
case $USER_FACTORY in
	1)# M39G_MV_2-3485 - Erase /cache partition
		# fix partition only if really unmountable
		if ! [ "$(df | grep cache)" ]; then
			flash_eraseall /dev/mtd/mtd4
			REBOOT_REQ=1
		fi
		setprop persist.sys.ublx_ufactory.user 0;;
	2)# remove all FS and user files
		rm -rf /cache/RAMDUMP*
		rm -rf /cache/log
		rm -rf /data/userfs
		rm -rf /NVM/MtilSms*
		REBOOT_REQ=1
		setprop persist.sys.ublx_ufactory.user 0;;
esac

NVM_FACTORY=`getprop persist.sys.ublx_ufactory.nvm`
case $NVM_FACTORY in
	1)# restore all NVM settings
		rm /cache/MAKE_RAMDUMP
		mv /NVM/MtilSms* /tmp/
		rm -rf /NVM
		cp /marvell/tel/nvm_org/* /NVM
		rm -rf /data/property
		rm /data/userfs/audio/voice0.nvm
		rm /data/userfs/audio/voice1.nvm
		rm /data/userfs/audio/audio_gain_calibration0.xml
		rm /data/userfs/audio/audio_gain_calibration1.xml
		mv /tmp/MtilSms* /NVM/
		REBOOT_REQ=1;;
	2)# remove profiles only
		rm /NVM/Profile*
		rm /data/userfs/audio/voice0.nvm
		rm /data/userfs/audio/voice1.nvm
		rm /data/userfs/audio/audio_gain_calibration0.xml
		rm /data/userfs/audio/audio_gain_calibration1.xml
		REBOOT_REQ=1
		setprop persist.sys.ublx_ufactory.nvm 0;;
esac

if [ $REBOOT_REQ == '1' ]; then
	reboot
fi
