<?php
/*
 * This Class sets global variables that every page use.
 *
 * $Revision: 3583 $
 * $Author: PENET\roncsak $
 * $Date: 2014-06-25 09:52:22 +0200 (Wed, 25 Jun 2014) $
 *
 **/

class PageBuilder {
  
	public $id;
	public $tpl;
	public $mode;
	public $lang;
	public $theme;
	public $title;
	public $project;
	public $subtitle;
	public $project_name;
	public $admin_authed;
	public $password_protection;
	
  
	public function __construct( $id ) {
		global $_SESSION, $smarty ;
		
		if( !empty($id) ) {
			$smarty->configLoad('default.conf', 'project');
			if( empty($_SESSION['theme']) ) {
				$this->project	= $smarty->getConfigVars('project');
			} else {
				$this->project = $_SESSION['theme'];
			}
			$this->mode		= $smarty->getConfigVars('mode');
			
			// Set theme
			// if( empty($_SESSION['theme']) ) {
				// $_SESSION['theme'] = "default";
			// }
			$smarty->configLoad($this->project.'.conf');
			$this->theme = $smarty->getConfigVars('theme');
			// $this->theme = $_SESSION['theme'];
			
			// Set user readable project name
			$this->project_name = $smarty->getConfigVars('name');
			
			// Set id
			$this->id	= $id;
			
			// Set WUI authentication
			// Admin password accepted or not
			if( empty($_SESSION['admin_authed']) ) {
				$_SESSION['admin_authed'] = 0;
			}
			$this->admin_authed = $_SESSION['admin_authed'];
			
			// Set tpl
			if( !$this->admin_authed && strstr($this->id, "settings") ) {
				$this->tpl = $this->project."_page-settings-login.tpl.html";
			} else if( $this->id == "themes" ) {
				$this->tpl = "themes.tpl.html";
			} else {
				$this->tpl = $this->project."_page-".$this->id.".tpl.html";
			}
			
			// Set current language
			if( empty($_SESSION['lang']) ) {
				$_SESSION['lang'] = "en";
			}
			$this->lang = $_SESSION['lang'];
			
			// Set page title and subtitle
			$smarty->configLoad($this->lang.'.lang');
			if( strstr($this->id, "settings") != false ) {
				$this->title = $smarty->getConfigVars( 'page_settings_title' );
				$this->subtitle = $smarty->getConfigVars( 'page_'.str_replace('-', '_', $this->id).'_title' );
			} else {
				// $this->title = $smarty->getConfigVars( $this->id.'_pagetitle' ); // This will be deprecated
				$this->title = $smarty->getConfigVars( 'page_'.$this->id.'_title' );
			}
		}
	}
	public function SetLanguageCode( $langcode ) {
		$_SESSION['lang'] = $langcode;
		$this->lang = $langcode;
	}
	public function SetPasswordProtection( $password_protection ) {
		$this->password_protection = $password_protection;
	}
}
?>
