<?php
/*áé*/
require_once('init.php');
require_once('_lw2TobyConnector.php');
require_once('_pageBuilder.php');
$conn = new LWUCI_Connector();

$page = new PageBuilder("sim-setup");

$json = $conn->read("pageSystem");
$page->SetLanguageCode($json['settings']['system']['language']);
$page->SetPasswordProtection($json['settings']['system']['pass_prot']);

$smarty->configLoad($page->project.'.conf', 'languages');
$json['settings']['system']['language'] = $page->lang;
$json['settings']['system']['languages'] = $smarty->getConfigVars('language');

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

$iccid = $conn->read("sim_current_iccid");
$sim_status = $conn->read("sim_status");
$sim_setup = $_SESSION['sim-setup'];
switch($sim_status) {
	case "PIN_NEEDED":
		$sim_setup = "pin-input";
		break;
	case "PIN_OK":
		if( empty($sim_setup) ) {
			$sim_setup = "profile-select";
		}
		break;
	case "PUK_NEEDED":
		$sim_setup = "puk-input";
		break;
	default:
		break;
}
//~ $sim_setup = "pin-input";
switch( $sim_setup ) {
	case "pin-input":
		$attempts = $conn->read("sim_attempts");
		$json['sim_status']['attempts'] = $attempts;
		break;
	case "pin-change":
		if( $sim_status == "PIN_OK" ) {
			$json['sim_status']['iccid'] = $iccid;
		} else {
			print '<meta http-equiv="refresh" content="0;url=./" />';
			exit();
		}
		break;
	case "pin-ok":
		$json['sim_status']['iccid'] = $iccid;
		break;
	case "profile-select":
		if( $sim_status == "PIN_OK" ) {
			require_once('_ServiceProviders.php');
			$imsi = json_decode($conn->read("sim_".$iccid."_imsi"), true);
			$sp = new ServiceProviders( (string) $imsi['mcc'], (string) $imsi['mnc']);
			$profiles = $sp->getResults();
			$json['sim_status']['profiles'] = $profiles;
			$json['sim_status']['iccid'] = $iccid;
		} else {
			print '<meta http-equiv="refresh" content="0;url=./" />';
			exit();
		}
		break;
	case "puk-input":
		$attempts = $conn->read("sim_attempts");
		$json['sim_status']['attempts'] = $attempts;
	default:
		break;
}
$smarty->assign('sim_setup', $sim_setup);
$smarty->assign('lwuci', $json);
$smarty->assign('page', $page);
$smarty->display('_template.tpl.html');
?>
